
//Program to find out unsymmetrical fault current//
//This program requires user input. A sample problem with user input and output is available in the result file. Question is available in the file"UnsymmetricalFaultQuestionFile.jpg" and result is available in the file"UnsymmetricalFaultResultFile.jpg"//
//Scilab Version 5.5.2 ; OS:Windows
clc ;
clear;
a=input('Enter the positve sequence,negative sequence and zero sequence of first generator in matrix form:')
PG1=a(:,1);//positive sequence of generator 1 is stored in the variable PG1
NG1=a(:,2);//negative sequence of generator 1 is stored in the variable NG1
ZG1=a(:,3);//negative sequence of generator 1 is stored in the variable ZG1
b=input('Enter the positve sequence,negative sequence and zero sequence of first transformer in matrix form:')
PT1=b(:,1);//positive sequence of transformer 1 is stored in the variable PT1
NT1=b(:,2);//positive sequence of transformer 1 is stored in the variable NT1
ZT1=b(:,3);//positive sequence of transformer 1 is stored in the variable ZT1
c=input('Enter the positve sequence,negative sequence and zero sequence of first transmission line in matrix form:')
PTL=c(:,1);//positive sequence of transmission line 1 is stored in the variable PTL
NTL=c(:,2);//positive sequence of transmission line 1 is stored in the variable NTL
ZTL=c(:,3);//positive sequence of transmission line 1 is stored in the variable ZTL
d=input('Enter the positve sequence,negative sequence and zero sequence of second transformer in matrix form:')
PT2=d(:,1);//positive sequence of transformer is stored in the variable PT2
NT2=d(:,2);//positive sequence of transformer 1 is stored in the variable NT2
ZT2=d(:,3);//positive sequence of transformer 1 is stored in the variable ZT2
e=input('Enter the positive sequence,negative sequence and zero sequence of second generator in matrix form:')
PG2=e(:,1);//positive sequence of transformer 1 is stored in the variable PG2
NG2=e(:,2);//positive sequence of transformer 1 is stored in the variable NG2
ZG2=e(:,3);//positive sequence of transformer 1 is stored in the variable ZG2
MVAB=input('Enter the value of base MVA:');
KVB=input('Enter the value of base KV:');
z1=((PG1*%i+PT1*%i)*(PTL*%i+PT2*%i+PG2*%i))/((PG1*%i+PT1*%i)+(PTL*%i+PT2*%i+PG2*%i));//calculation of positive impedence
z2=((NG1*%i+NT1*%i)*(NTL*%i+NT2*%i+NG2*%i))/((NG1*%i+NT1*%i)+(NTL*%i+NT2*%i+NG2*%i));//calculation of negative impedence
z0=((ZG1*%i+ZT1*%i)*(ZTL*%i+ZT2*%i+ZG2*%i))/((ZG1*%i+ZT1*%i)+(ZTL*%i+ZT2*%i+ZG2*%i));//calculation of zero impedence
Ib=(MVAB*(10^6))/((1.732*KVB*(10^3)))//calculating base current
disp(z0,z2,z1,'the values of positive(z1) negative(z2),zero(z0) sequence impedance  respectively are');
disp('OPTION','LG FAULT=1','LL FAULT=2','LLG FAULT=3');
MENU=input('Enter the choice of fault:')
if MENU==1 //calculating Line to Ground fault
    If=(3*(1))/(z0+z1+z2)
    FAULTCURRENT=If*Ib;
    disp(FAULTCURRENT,'The fault current is :');
end
if MENU==2//Calculating Line to Line Fault
    If=((-1.732j)*(1))/(z1+z2)
    FAULTCURRENT=If*Ib;
disp(FAULTCURRENT,'The fault current is :');
end
if MENU==3//calculating Line-Line-Ground fault
    z=(z0*z2)/(z0+z2);
    Ia1=(1)/(z1+z);
    Ia0=((-1+(Ia1*z1))/z0);
    If=3*Ia0;
    FAULTCURRENT=If*Ib;
 disp(FAULTCURRENT,'The fault current is :');
end

//SAMPLE INPUT and OUTPUT

//Enter the positve sequence,negative sequence and zero sequence of first generator in matrix form:[0.32 0.26 0.09]
//Enter the positve sequence,negative sequence and zero sequence of first transformer in matrix form:[0.23 0.23 0.23]
//Enter the positve sequence,negative sequence and zero sequence of first transmission line in matrix form:[0.56 0.56 0.09]
//Enter the positve sequence,negative sequence and zero sequence of second transformer in matrix form:[0.16 0.16 0.16]
//Enter the positive sequence,negative sequence and zero sequence of second generator in matrix form:[0.38 0.24 0.15]
//Enter the value of base MVA:100
//Enter the value of base KV:110
 
// the values of positive(z1) negative(z2),zero(z0) sequence impedance  respectivel 
//      y are                                                                       
 
//    0.3666667i  
 
//    0.3244138i  
 
//    0.1777778i  
 
// LLG FAULT=3   
 
// LL FAULT=2   
 
// LG FAULT=1   
 
// OPTION   
//Enter the choice of fault:3
 
// The fault current is :   
 
//    2112.5397i 
